#include <stdio.h>
#include <stdlib.h>
#include <algorithm>
#include <vector>
#include <math.h>
using namespace std;

struct Rope {
    long long t, c; 
};

long long distToIntervalExcl(long long L, long long R, long long xi) {
    const long long INF = (long long)4e18;
    if (L > R) return INF;
    if (xi < L) return L - xi;
    if (xi > R) return xi - R;
    bool canLeft = (xi > L);
    bool canRight = (xi < R);
    if (canLeft || canRight) return 1;
    return INF; 
}

int main() {
    int n;
    if (scanf("%d", &n) != 1) return 0;

    vector<long long> x(n), h(n);
    for (int i = 0; i < n; i++) scanf("%lld", &x[i]);
    for (int i = 0; i < n; i++) scanf("%lld", &h[i]);

    vector<int> ord(n);
    for (int i = 0; i < n; i++) ord[i] = i;
    sort(ord.begin(), ord.end(), [&](int a, int b){ return x[a] < x[b]; });

    vector<long long> xs(n), hs(n);
    for (int i = 0; i < n; i++) {
        xs[i] = x[ord[i]];
        hs[i] = h[ord[i]];
    }

    vector<Rope> rope(max(0, n - 1));
    for (int i = 0; i + 1 < n; i++) {
        long long t = (hs[i] - hs[i+1] + xs[i] + xs[i+1]) / 2; 
        long long c = hs[i] - llabs(xs[i] - t);                
        rope[i] = {t, c};
    }

    const long long INF = (long long)4e18;
    vector<long long> ansSorted(n, -1);

    for (int i = 0; i < n; i++) {
        long long xi = xs[i], Hi = hs[i];
        long long best = INF;

        for (int j = 0; j < n; j++) {
            if (j == i) continue; 
            if (hs[j] >= Hi) {
                long long d = llabs(xs[j] - xi);
                if (d < best) best = d;
            }
        }

        if (i - 1 >= 0) {
            long long t = rope[i - 1].t, c = rope[i - 1].c;
            long long r = c - Hi; 
            if (r >= 0) {
                long long L = max(xs[i - 1], t - r);
                long long R = min(xs[i],     t + r);
                long long d = distToIntervalExcl(L, R, xi);
                if (d < best) best = d;
            }
        }
        if (i + 1 < n) {
            long long t = rope[i].t, c = rope[i].c;
            long long r = c - Hi;
            if (r >= 0) {
                long long L = max(xs[i],     t - r);
                long long R = min(xs[i + 1], t + r);
                long long d = distToIntervalExcl(L, R, xi);
                if (d < best) best = d;
            }
        }

        ansSorted[i] = (best == INF ? -1 : best);
    }

    vector<long long> ans(n);
    for (int i = 0; i < n; i++) ans[ord[i]] = ansSorted[i];

    for (int i = 0; i < n; i++) {
        printf("%lld\n", ans[i]);
    }
    return 0;
}